package com.atlassian.bitbucket.server;

/**
 * The current state of the server.
 *
 * Possible state transitions are:
 * <ul>
 *     <li>STARTING -&gt; (FIRST_RUN | RUNNING | ERROR | STOPPING)</li>
 *     <li>FIRST_RUN -&gt; (RUNNING | MAINTENANCE | ERROR | STOPPING)</li>
 *     <li>RUNNING -&gt; (MAINTENANCE | ERROR | STOPPING)</li>
 *     <li>ERROR -&gt; (RUNNING | STOPPING)</li>
 *     <li>MAINTENANCE -&gt; (RUNNING | ERROR | STOPPING)</li>
 *     <li>STOPPING -&gt;</li>
 * </ul>
 *
 */
public enum ApplicationState {

    /**
     * The application is starting up, but not yet available
     */
    STARTING,
    /**
     * The application is running for the first time and has not yet been configured. All requests to the web UI will
     * be redirected to the First Run Wizard.
     */
    FIRST_RUN,
    /**
     * The application has been setup and is running normally
     */
    RUNNING,
    /**
     * The application is currently not available because the application is under maintenance
     */
    MAINTENANCE,
    /**
     * The application is currently not available because of an error
     */
    ERROR,
    /**
     * The application is shutting down
     */
    STOPPING,
    /**
     * The application state is indeterminate.
     */
    UNKNOWN,
}
