package com.atlassian.bitbucket.scope;

import com.atlassian.bitbucket.project.Project;

import javax.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

import static java.util.Objects.requireNonNull;

/**
 * Describes a project level scope
 *
 * @since 5.0
 */
public class ProjectScope implements Scope {

    private final Project project;

    public ProjectScope(@Nonnull Project project) {
        this.project = requireNonNull(project, "project");
    }

    public <T> T accept(@Nonnull ScopeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ProjectScope) {
            ProjectScope that = (ProjectScope) o;

            return Objects.equals(getProject(), that.getProject());
        }

        return false;
    }

    /**
     * @return the project
     */
    @Nonnull
    public Project getProject() {
        return project;
    }

    @Nonnull
    @Override
    public Optional<Integer> getResourceId() {
        return Optional.of(project.getId());
    }

    @Nonnull
    public ScopeType getType() {
        return ScopeType.PROJECT;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(getProject());
    }

    @Override
    public String toString() {
        return "ProjectScope{project=" + project.toString() + "}";
    }
}
