package com.atlassian.bitbucket.scm.pull;

import com.atlassian.bitbucket.content.ChangeContext;
import com.atlassian.bitbucket.scm.AbstractChangesCommandParameters;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since 6.0
 */
public class PullRequestChangesCommandParameters extends AbstractChangesCommandParameters {

    private PullRequestChangesCommandParameters(Builder builder) {
        super(builder);
    }

    /**
     * Assembles a {@link ChangeContext} from these parameters using the hashes from the
     * {@link PullRequestEffectiveDiff current effective diff}.
     *
     * @param effectiveDiff the current {@link PullRequestEffectiveDiff effective diff} for the pull request
     * @return a {@link ChangeContext} describing these parameters
     */
    @Nonnull
    public ChangeContext toContext(@Nonnull PullRequestEffectiveDiff effectiveDiff) {
        requireNonNull(effectiveDiff, "effectiveDiff");

        return toContext(new ChangeContext.Builder(effectiveDiff.getSinceId(), effectiveDiff.getUntilId()));
    }

    public static class Builder extends AbstractBuilder<Builder> {

        public Builder() {
        }

        @Nonnull
        public PullRequestChangesCommandParameters build() {
            return new PullRequestChangesCommandParameters(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
