package com.atlassian.bitbucket.scm.mirror;

import com.atlassian.bitbucket.scm.AuthenticationFailedScmException;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.NotAuthorizedScmException;

import javax.annotation.Nonnull;

/**
 * @since 4.1
 */
public interface ScmMirrorCommandFactory {

    /**
     * Creates a command that fetches all branches and tags from the provided
     * {@link MirrorSyncCommandParameters#getRemoteUrl() remote URL}. The fetched branches and tags overwrite any
     * local branches and tags, and local branches and tags that are not present in the remote repository are deleted.
     * Starting from 4.11, the command throws an {@link AuthenticationFailedScmException} if the fetch fails because of
     * authentication issues, or a {@link NotAuthorizedScmException} if the fetch fails because of authorization issues.
     *
     * @param parameters describes what to synchronize
     * @param callback callback to process synchronization details
     * @return the command
     */
    @Nonnull
    Command<Void> synchronize(@Nonnull MirrorSyncCommandParameters parameters, @Nonnull MirrorSyncCallback callback);

    /**
     * Applies the provided {@link com.atlassian.bitbucket.repository.RefChange ref changes} in the repository. If one
     * or more of the updates cannot be performed (e.g. the toHash does not exist in the repository or the fromHash
     * does not match the current value in the repository), the command will apply all ref updates that can be safely
     * applied, then throw a {@link MirrorUpdateRefsCommandFailedException}.
     *
     * @param parameters describes what ref changes to apply
     * @return the command
     * @since 4.2
     */
    @Nonnull
    Command<Void> updateRefs(@Nonnull MirrorUpdateRefsCommandParameters parameters);
}
