package com.atlassian.bitbucket.scm.bulk;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.scm.Command;

import javax.annotation.Nonnull;

/**
 * @since 4.2
 */
public interface ScmBulkContentCommandFactory {

    /**
     * Streams commits from one or more repositories, providing a set of matching repositories for each.
     * <p>
     * Due to the bulk nature of this method, it is <i>required</i> that full {@link Commit#getId IDs} be used to
     * identify the commits to be streamed. <i>Short IDs, including {@link Commit#getDisplayId display IDs}, will
     * not work.</i>
     *
     * @param parameters parameters describing the commits to stream
     * @param callback   a callback to receive the requested commits
     * @return a command which, when {@link Command#call called}, will stream commits to the provided callback
     * @since 5.8
     */
    @Nonnull
    Command<Void> commits(@Nonnull BulkCommitsCommandParameters parameters, @Nonnull BulkCommitCallback callback);

    /**
     * @param parameters parameters describing the content to stream
     * @param callback   a callback to receive the content
     * @return a command which, when {@link Command#call called}, will stream content to the provided callback
     */
    @Nonnull
    Command<Void> contents(@Nonnull BulkContentCommandParameters parameters, @Nonnull BulkContentCallback callback);

    /**
     * Stream commits from one or more repositories, traversed in topological order.
     *
     * @param parameters parameters describing commits to include in the traversal
     * @param callback   the callback to receive the streamed commits
     * @return a command which, when {@link Command#call called}, will stream a topological traversal of the specified
     *         commits
     * @since 5.11
     */
    @Nonnull
    Command<Void> traverseCommits(@Nonnull BulkTraverseCommitsCommandParameters parameters,
                                  @Nonnull BulkTraversalCallback callback);
}
