package com.atlassian.bitbucket.scm.bulk;

/**
 * Returned by {@link BulkContentCallback#accept} to signal what to do next to the caller.
 *
 * @since 4.2
 */
public enum BulkContentDisposition {

    /**
     * Skip the current file, and do not offer any further files. This can be used to terminate streaming early.
     */
    DONE,

    /**
     * Stream the current file, allowing its bytes to be read. For deleted files, this is equivalent to SKIP.
     */
    STREAM,

    /**
     * Skip the current file, but continue offering subsequent files. This can be used to implement filtering,
     * rejecting some files but accepting others based on the {@link BulkFile}.
     */
    SKIP
}
