package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.repository.RepositoryTagsRequest;

import javax.annotation.Nonnull;

public class TagsCommandParameters extends AbstractRefsCommandParameters {

    private TagsCommandParameters(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder> {

        public Builder() {
        }

        /**
         * @param request the request to copy parameters from
         * @since 5.1
         */
        public Builder(@Nonnull RepositoryTagsRequest request) {
            super(request);
        }

        @Nonnull
        public TagsCommandParameters build() {
            return new TagsCommandParameters(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
