package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * Base class for exceptions thrown by the {@link ScmService} and other SCM components.
 * <p>
 * Plugin developers providing SCM implementations are encouraged to derive exceptions which will be propagated beyond
 * their implementation boundaries from this exception.
 */
public abstract class ScmException extends ServiceException {

    private final String scmId;

    protected ScmException(@Nonnull KeyedMessage message, @Nonnull String scmId) {
        this(message, null, scmId);
    }

    protected ScmException(@Nonnull KeyedMessage message, @Nullable Throwable cause, @Nonnull String scmId) {
        super(message, cause);

        this.scmId = requireNonNull(scmId, "scmId");
    }

    /**
     * Retrieves the unique identifier for the SCM from which, or for which, this exception was thrown.
     *
     * @return the SCM identifier
     */
    @Nonnull
    public String getScmId() {
        return scmId;
    }
}
