package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.scm.mirror.ScmMirrorCommandFactory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * An exception that is thrown by {@link Command commands} created by the {@link ScmMirrorCommandFactory} when they
 * fail due to authorization problems.
 *
 * @since 4.11
 */
public class NotAuthorizedScmException extends ScmException {

    public NotAuthorizedScmException(@Nonnull KeyedMessage message, @Nonnull String scmId) {
        this(message, null, scmId);
    }

    public NotAuthorizedScmException(@Nonnull KeyedMessage message, @Nullable Throwable cause, @Nonnull String scmId) {
        super(message, cause, scmId);
    }

}
