package com.atlassian.bitbucket.scm;

import javax.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;

/**
 * Describes an {@code InputHandler} which provides data to the standard input stream for a {@link Command} to process.
 * <p>
 * The format of data a command expects to receive on standard input, if any, is highly command-specific. As a result,
 * nothing about the format of the data provided by this handler is proscribed by this interface; instead, it is left
 * to the implementor to understand the needs of the command they are executing and provide appropriate input.
 *
 * @see CommandAware
 */
public interface CommandInputHandler extends CommandHandlerSupport {

    void process(@Nonnull OutputStream input) throws IOException;
}
