package com.atlassian.bitbucket.scm;

import javax.annotation.Nonnull;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * An interface to be implemented by a {@link CommandErrorHandler}, {@link CommandInputHandler} or
 * {@link CommandOutputHandler} that wishes to be provided the {@link Command} it will be processing.
 * The command will be set before the handler's relevant {@code process} method is called.
 *
 * @since 6.1
 */
public interface CommandAware {

    /**
     * Called prior to {@code process} to provide the {@link Command} the handler will be processing.
     *
     * @param command the command for which the handler will process input or output
     * @see CommandErrorHandler#process(InputStream)
     * @see CommandInputHandler#process(OutputStream)
     * @see CommandOutputHandler#process(InputStream)
     */
    void setCommand(@Nonnull Command<?> command);
}
