package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Basic implementation of {@link MinimalRepositoryRef}
 *
 * @since 5.0
 */
public class SimpleMinimalRepositoryRef extends SimpleMinimalRef implements MinimalRepositoryRef {

    private final Repository repository;

    protected SimpleMinimalRepositoryRef(@Nonnull AbstractBuilder<?, ?> builder) {
        super(requireNonNull(builder, "builder"), builder.type);

        repository = builder.repository;
    }

    @Nonnull
    @Override
    public Repository getRepository() {
        return repository;
    }

    public static class Builder extends AbstractBuilder<Builder, SimpleMinimalRepositoryRef> {

        public Builder(@Nonnull Repository repository) {
            super(repository);
        }

        public Builder(@Nonnull SimpleMinimalRepositoryRef ref) {
            super(ref);
        }

        @Nonnull
        @Override
        public SimpleMinimalRepositoryRef build() {
            return new SimpleMinimalRepositoryRef(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }

    protected abstract static class AbstractBuilder<B extends AbstractBuilder<B, R>, R extends MinimalRepositoryRef>
            extends AbstractMinimalRefBuilder<B, R> {

        private final Repository repository;
        private RefType type;

        protected AbstractBuilder(@Nonnull Repository repository) {
            this.repository = requireNonNull(repository, "repository");
        }

        protected AbstractBuilder(@Nonnull Repository repository, @Nonnull MinimalRef ref) {
            this.repository = requireNonNull(repository, "repository");

            displayId(requireNonNull(ref, "ref").getDisplayId());
            id(ref.getId());
            type(ref.getType());
        }

        protected AbstractBuilder(@Nonnull R ref) {
            super(ref);

            this.repository = requireNonNull(ref.getRepository(), "ref.repository");
        }

        @Nonnull
        public B type(@Nonnull RefType value) {
            type = requireNonNull(value, "type");

            return self();
        }
    }
}
