package com.atlassian.bitbucket.repository;

/**
 * The visibility of a given {@link Repository repository}.
 *
 * @see RepositorySearchRequest#getVisibility()
 */
public enum RepositoryVisibility {
    /**
     * Indicates that a repository is accessible <em>only</em> to <strong>authenticated</strong> users
     */
    PRIVATE,
    /**
     * Indicates that a repository is accessible to <strong>unauthenticated</strong> users
     */
    PUBLIC
}
