package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;

/**
 * A request for branches within a repository. The purpose and behaviour of each field is described on its accessor.
 */
public class RepositoryBranchesRequest extends AbstractRepositoryRefsRequest {

    private RepositoryBranchesRequest(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, RepositoryBranchesRequest> {

        public Builder(@Nonnull Repository repository) {
            super(repository);
        }

        @Nonnull
        public RepositoryBranchesRequest build() {
            return new RepositoryBranchesRequest(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
