package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import java.nio.file.Path;

import static java.util.Objects.requireNonNull;

/**
 * Thrown to indicate that a {@link Repository repository} already exists at the given
 * {@link #getRepositoryDir repositoryDir} when a new repository or fork is created.
 *
 * @since 4.8
 */
public class RepositoryAlreadyExistsException extends IllegalRepositoryStateException {

    private final Path repositoryDir;

    public RepositoryAlreadyExistsException(@Nonnull KeyedMessage message,
                                            @Nonnull Path repositoryDir) {
        super(message);
        this.repositoryDir = requireNonNull(repositoryDir, "repositoryDir");
    }

    /**
     * @return the path of the repository that already exists.
     */
    @Nonnull
    public Path getRepositoryDir() {
        return repositoryDir;
    }
}
