package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;

/**
 * A minimal abstraction for a ref within a {@link Repository}, describing only the ref's name.
 */
public interface MinimalRef {

    /**
     * An identifier for this reference suitable for display to end users.
     * <p>
     * No guarantees are made as to how this identifier differs from {@link #getId()}--they may be identical or not, at
     * the whim of the underlying SCM implementation. In practise, however, the returned identifier should be sensible
     * for users familiar with the underlying SCM.
     *
     * @return the reference's display identifier
     */
    @Nonnull
    String getDisplayId();

    /**
     * The absolute identifier of this reference, which should never be ambiguous within the backing {@link Repository}.
     * <p>
     * When performing operations which accept a commit ID, this is the value that should be used to ensure there are
     * no ambiguities. Using {@link #getDisplayId()} may result in unexpected behaviour.
     *
     * @return the reference's absolute identifier
     */
    @Nonnull
    String getId();

    /**
     * @return the type of ref
     */
    @Nonnull
    RefType getType();
}
