package com.atlassian.bitbucket.repository;

import javax.annotation.Nonnull;

/**
 * A request to create a {@link com.atlassian.bitbucket.repository.Branch branch}.
 */
public class CreateBranchRequest extends AbstractCreateRefRequest {

    public CreateBranchRequest(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, CreateBranchRequest> {

        public Builder(@Nonnull Repository repository, @Nonnull String name, @Nonnull String startPoint) {
            super(repository, name, startPoint);
        }

        @Nonnull
        public CreateBranchRequest build() {
            return new CreateBranchRequest(this);
        }

        @Nonnull
        @Override
        public Builder self() {
            return this;
        }
    }
}
