package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;

import javax.annotation.Nonnull;
import java.util.SortedMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class SimplePullRequestActivityPage<T extends PullRequestActivity> implements PullRequestActivityPage<T> {

    private final Page<T> page;
    private final long previousPageStartId;

    public SimplePullRequestActivityPage(Page<T> page, long previousPageStartId) {
        this.page = page;
        this.previousPageStartId = previousPageStartId;
    }

    @Override
    public void forEach(@Nonnull Consumer<? super T> action) {
        page.forEach(action);
    }

    @Override
    public boolean getIsFirstPage() {
        return previousPageStartId == NO_ID;
    }

    @Override
    public boolean getIsLastPage() {
        return page.getIsLastPage();
    }

    @Override
    public int getLimit() {
        return page.getLimit();
    }

    @Override
    public PageRequest getNextPageRequest() {
        return page.getNextPageRequest();
    }

    @Nonnull
    @Override
    public SortedMap<Integer, T> getOrdinalIndexedValues() {
        return page.getOrdinalIndexedValues();
    }

    @Override
    public long getPreviousPageStartId() {
        return previousPageStartId;
    }

    @Override
    public int getSize() {
        return page.getSize();
    }

    @Override
    public int getStart() {
        return page.getStart();
    }

    @Nonnull
    @Override
    public Iterable<T> getValues() {
        return page.getValues();
    }

    @Nonnull
    @Override
    public Stream<T> stream() {
        return page.stream();
    }

    @Nonnull
    @Override
    public <E> Page<E> transform(@Nonnull Function<? super T, ? extends E> transformFunction) {
        return page.transform(transformFunction);
    }
}
