package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.google.common.collect.ImmutableList;

import javax.annotation.Nonnull;
import java.util.Collection;

import static java.util.Objects.requireNonNull;

/**
 * Indicates a pull request merge request was vetoed by one or more merge-check plugin modules.
 */
public class PullRequestMergeVetoedException extends ServiceException {

    private final Collection<PullRequestMergeVeto> vetoes;
    private boolean conflicted;

    public PullRequestMergeVetoedException(KeyedMessage message, @Nonnull Collection<PullRequestMergeVeto> vetoes, boolean conflicted) {
        super(message);
        this.vetoes = ImmutableList.copyOf(requireNonNull(vetoes, "vetoes"));
        this.conflicted = conflicted;
    }

    @Nonnull
    public Collection<PullRequestMergeVeto> getVetoes() {
        return vetoes;
    }

    public boolean isConflicted() {
        return conflicted;
    }
}
