package com.atlassian.bitbucket.pull;

/**
 * {@link PullRequestMergeConfig Configuration} for pull request merge strategies can be applied at different
 * levels, which are described here.
 *
 * @since 4.9
 */
public enum PullRequestMergeConfigType {

    /**
     * Merge strategies have not been explicitly configured at any level, so the SCM's defaults are being used.
     */
    DEFAULT,
    /**
     * Merge strategies have been configured for the project. This is more specific than {@link #SCM} level
     * configuration, but can be overridden by {@link #REPOSITORY repository} level configuration.
     */
    PROJECT,
    /**
     * Merge strategies have been configured for the repository. This is the most specific level of configuration,
     * overriding {@link #PROJECT project} and {@link #SCM} level configuration, and cannot be overridden by
     * configuration at any other level.
     */
    REPOSITORY,
    /**
     * Merge strategies have been configured globally for all repositories using this SCM. This is the least
     * specific level of configuration, and can be overridden by configuration at the {@link #PROJECT project}
     * or {@link #REPOSITORY repository} level.
     */
    SCM
}
