package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.commit.Commit;

import javax.annotation.Nullable;

/**
 * A {@link PullRequestActivity} representing when the pull request was merged.
 * <p>
 * Note that merging pull requests is delegated to the SCM implementation, which might support multiple strategies for
 * merging the changes into the target branch. As such the type of the merge {@link #getCommit() commit} should not
 * be assumed.
 * <p>
 * Also note that the merge {@link #getCommit() commit} and {@link #getCommitId() commit ID} can be {@code null}
 * if the pull request was merged remotely and pushed rather than being merged via the UI or REST.
 *
 * @see PullRequestActivityType#MERGE
 */
public interface PullRequestMergeActivity extends PullRequestActivity {

    /**
     * @return the merge commit, which may be {@code null} if the pull request was merged remotely
     *         or activity has been not enriched
     */
    @Nullable
    Commit getCommit();

    /**
     * @return the merge commit ID, if the merge was performed by the system, or {@code null} if it was done remotely
     * @since 7.15
     */
    @Nullable
    String getCommitId();

    /**
     * @return {@code true} if the merge was done remotely; otherwise, {@code false} if it was done by the system
     * @since 7.15
     */
    boolean isRemote();
}
