package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;

/**
 * @since 5.2
 */
public class DeletePullRequestMergeConfigRequest extends AbstractPullRequestMergeConfigRequest {

    private DeletePullRequestMergeConfigRequest(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, DeletePullRequestMergeConfigRequest> {

        public Builder(@Nonnull Project project, @Nonnull String scmId) {
            super(project, scmId);
        }

        public Builder(@Nonnull Repository repository) {
            super(repository);
        }

        public Builder(@Nonnull String scmId) {
            super(scmId);
        }

        @Nonnull
        @Override
        public DeletePullRequestMergeConfigRequest build() {
            return new DeletePullRequestMergeConfigRequest(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
