package com.atlassian.bitbucket.project;

import javax.annotation.Nonnull;

/**
 * Implements the visitor pattern for {@link Project projects}.
 * <p>
 * Note: Implementors are <i>strongly</i> encouraged to extend from {@link AbstractProjectVisitor} or
 * {@link AbstractVoidProjectVisitor}. This interface <i>will</i> change over time, as more
 * {@link ProjectType project types} are added, and any class implementing it directly will be broken
 * by such changes. Extending from one of the abstract classes will help prevent such breakages.
 */
public interface ProjectVisitor<T> {

    T visit(@Nonnull Project project);

    T visit(@Nonnull PersonalProject project);
}
