package com.atlassian.bitbucket.project;

import com.atlassian.bitbucket.EntityMovedException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Exception that is thrown when a {@link Project#getKey() project key} has been changed and the project is retrieved 
 * using the old key.
 *
 * @since 5.0
 */
public class ProjectMovedException extends EntityMovedException {

    private static final long serialVersionUID = 1L;

    private final String oldKey;
    private final Project project;

    /**
     * @since 7.18
     */
    public ProjectMovedException(@Nonnull Project project, @Nonnull String projectKey, @Nonnull KeyedMessage message) {
        super(message);

        this.oldKey = projectKey;
        this.project = project;
    }

    @Nonnull
    public String getOldKey() {
        return oldKey;
    }

    @Nonnull
    public Project getProject() {
        return project;
    }
}
