package com.atlassian.bitbucket.project;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * A base implementation of {@link ProjectVisitor} which returns {@code null} for all project types.
 */
public abstract class AbstractProjectVisitor<T> implements ProjectVisitor<T> {

    private final T defaultValue;

    public AbstractProjectVisitor() {
        this(null);
    }

    /**
     * @param defaultValue the value to return when visiting a project, if not overridden in a subclass
     */
    protected AbstractProjectVisitor(@Nullable T defaultValue) {
        this.defaultValue = defaultValue;
    }

    /**
     * @param project ignored
     * @return {@code null}
     */
    @Override
    public T visit(@Nonnull Project project) {
        return defaultValue;
    }

    /**
     * @param project ignored
     * @return {@code null}
     */
    @Override
    public T visit(@Nonnull PersonalProject project) {
        return defaultValue;
    }
}
