package com.atlassian.bitbucket.migration.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.job.Job;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when an Data Center Migration import has completed executing.
 * <p>
 * To determine whether the import has finished successfully, the {@link #getFinalState() state} should be inspected.
 *
 * @since 5.13
 */
@AsynchronousPreferred
@EventName("stash.migration.import.finished")
public class MigrationImportFinishedEvent extends MigrationExportFinishedEvent {

    public MigrationImportFinishedEvent(@Nonnull Object source, @Nonnull Job job, long errorCount,
                                        long infoCount, long warningCount) {
        super(source, job, errorCount, infoCount, warningCount);
    }
}
