package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Runtime exception generated during export phase of migration
 *
 * @since 5.13
 */
public class ExportException extends MigrationException {

    public ExportException(@Nonnull KeyedMessage message) {
        super(message, null, null);
    }

    public ExportException(@Nonnull KeyedMessage message, @Nullable Object subject) {
        super(message, subject, null);
    }

    public ExportException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, null, cause);
    }

    public ExportException(@Nonnull KeyedMessage message, @Nullable Object subject, @Nullable Throwable cause) {
        super(message, subject, cause);
    }
}
