package com.atlassian.bitbucket.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * Thrown to indicate a Mesh-related operation could not be performed because a Data Center license is not installed.
 *
 * @since 8.0
 */
public class MeshUnavailableException extends ServiceException {

    public MeshUnavailableException(@Nonnull KeyedMessage message) {
        super(message, null);
    }
}
