package com.atlassian.bitbucket.mesh;

import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Thrown to indicate the specified RPC URL is invalid, either syntactically or semantically.
 *
 * @since 8.0
 */
public class InvalidMeshNodeUrlException extends IllegalEntityStateException {

    public InvalidMeshNodeUrlException(@Nonnull KeyedMessage message) {
        super(message);
    }

    public InvalidMeshNodeUrlException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
