package com.atlassian.bitbucket.mesh;

import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Thrown to indicate the specified {@link MeshNode.State} cannot be set, e.g. because the target state
 * is a transitional state like {@link MeshNode.State#OFFLINE}.
 *
 * @since 8.4
 */
public class InvalidMeshNodeStateException extends IllegalEntityStateException {

    public InvalidMeshNodeStateException(@Nonnull KeyedMessage message) {
        super(message);
    }

    public InvalidMeshNodeStateException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
