package com.atlassian.bitbucket.markup;

/**
 * A formatting mode for URLs. Used to specify to {@link MarkupService} method what to do with generated URLs.
 */
public enum UrlMode {
    /**
     * Absolute URL format, with URL scheme, hostname, port (if non-standard for the scheme), and context path.
     */
    ABSOLUTE,
    /**
     * Relative URL format, containing just the context path.
     */
    RELATIVE,
    /**
     * Configured URL format, <i>always</i> uses the system settings.
     */
    CONFIGURED,
}
