package com.atlassian.bitbucket.mail;

/**
 * Service used for formatting, scheduling and sending of emails.
 */
public interface MailService {

    /**
     * @return true if the mail host is configured.
     */
    boolean isHostConfigured();

    /**
     * Submit the {@link MailMessage} to the mail queue.
     *
     * @param mailMessage the message to send.
     * @throws NoMailHostConfigurationException if the mail host hasn't been configured
     * @throws MailQueueFullException if the mail queue is full and it cannot be queued
     * @throws MailSizeExceededException if the mail subject/body is too large
     */
    void submit(MailMessage mailMessage) throws NoMailHostConfigurationException, MailQueueFullException, MailSizeExceededException;
}
