package com.atlassian.bitbucket.mail;

import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nullable;
import java.util.Locale;

/**
 * An enumeration of the supported protocols when sending email withing the product.
 */
public enum MailProtocol {

    SMTP,
    SMTPS;

    public static MailProtocol fromString(@Nullable String value) {
        try {
            return StringUtils.isEmpty(value) ? SMTP : MailProtocol.valueOf(value.toUpperCase(Locale.US));
        } catch (IllegalArgumentException e) {
            return SMTP;
        }
    }
}
