package com.atlassian.bitbucket.license;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.i18n.KeyedMessage;

/**
 * Indicates that an attempt was made to change the license to one which does not support
 * clustering but there is an active cluster of two or more nodes
 *
 * @see ClusterService#isClustered()
 */
public class IncompatibleLicenseChangeException extends LicenseException {

    public IncompatibleLicenseChangeException(KeyedMessage message) {
        super(message);
    }

}
