package com.atlassian.bitbucket.job;

import javax.annotation.Nonnull;
import java.time.Instant;
import java.util.Optional;

/**
 * A message logged against a {@link Job job}, optionally associated with subject entity such as a project, repository
 * or pull request.
 *
 * @since 5.13
 */
public interface JobMessage {

    /**
     * @return when the message was created
     */
    @Nonnull
    Instant getCreatedDate();

    /**
     * @return the job message's ID
     */
    long getId();

    /**
     * @return the job this message relates to
     */
    @Nonnull
    Job getJob();

    /**
     * @return the severity of the message
     */
    @Nonnull
    JobMessageSeverity getSeverity();

    /**
     * @return an identifier or description of the subject the message relates to, or {@link Optional#empty()} if it's
     *         a job-level message
     */
    @Nonnull
    Optional<String> getSubject();

    /**
     * @return the string details of the message
     */
    @Nonnull
    String getText();
}