package com.atlassian.bitbucket.jira;

/**
 * This exception is thrown when the setup service can not retrieve the remote Jira server's UAL manifest (usually
 * available at /rest/applinks/1.0/manifest). This may happen because the supplied URL does not target a Jira server,
 * the Jira server pre-dates v4.3, or the Jira server is not responding normally (UAL is a system plugin that shouldn't
 * be disabled under normal circumstances).
 */
public class NotAJiraServerException extends JiraSetupException {

    public NotAJiraServerException(final String prettyUserMessage) {
        super(prettyUserMessage);
    }

    public NotAJiraServerException(final String prettyUserMessage, final Throwable cause) {
        super(prettyUserMessage, cause);
    }

}
