package com.atlassian.bitbucket.hook.script;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static java.util.Objects.requireNonNull;

/**
 * Fired when a {@link HookScript} is updated.
 *
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 *
 * @since 6.2
 */
@AsynchronousPreferred
@EventName("stash.hook.script.updated")
public class HookScriptUpdatedEvent extends HookScriptEvent {

    private final HookScript oldHookScript;

    /**
     * @since 7.4
     */
    public HookScriptUpdatedEvent(@Nonnull Object source, @Nonnull HookScript newHookScript,
                                  @Nonnull HookScript oldHookScript) {
        super(source, newHookScript);
        this.oldHookScript = requireNonNull(oldHookScript, "oldHookScript");
    }

    @Nullable
    public HookScript getOldHookScript() {
        return oldHookScript;
    }
}
