package com.atlassian.bitbucket.hook.script;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event fired when a {@link HookScript} configuration is removed.
 *
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 *
 * @since 6.2
 */
@AsynchronousPreferred
@EventName("stash.hook.script.configuration.removed")
public class HookScriptConfigurationRemovedEvent extends HookScriptConfigurationEvent {

    public HookScriptConfigurationRemovedEvent(@Nonnull Object source, @Nonnull HookScript hookScript,
                                               @Nonnull Scope scope) {
        super(source, hookScript, scope);
    }
}
