package com.atlassian.bitbucket.hook.repository;

import javax.annotation.Nonnull;

/**
 * Describes the trigger for a {@code repository-hook} invocation.
 *
 * @see StandardRepositoryHookTrigger for the built-in triggers
 * @see RepositoryHookService#preUpdate(RepositoryHookRequest)
 * @see RepositoryHookService#postUpdate(RepositoryHookRequest)
 *
 * @since 5.0
 */
public interface RepositoryHookTrigger {

    /**
     * @return the trigger identifier
     */
    @Nonnull
    String getId();

    /**
     * @return whether a {@link RepositoryHookService#preUpdate(RepositoryHookRequest)} invocation should stop calling
     *         other {@code repository-hook} modules after the first veto. Return {@code false} if all hooks need to be
     *         called even after one hook vetoes the request.
     */
    boolean isAbortOnFirstVeto();
}
