package com.atlassian.bitbucket.hook.repository;

import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.util.PageRequest;

import javax.annotation.Nonnull;
import java.util.Optional;

import static java.util.Objects.requireNonNull;

/**
 * Request object used for {@link RepositoryHookService#search(RepositoryHookSearchRequest, PageRequest)} searching repository hooks}.
 *
 * @since 5.2
 */
public class RepositoryHookSearchRequest {

    private final Scope scope;
    private final RepositoryHookType type;

    private RepositoryHookSearchRequest(Builder builder) {
        scope = builder.scope;
        type = builder.type;
    }

    @Nonnull
    public Scope getScope() {
        return scope;
    }

    @Nonnull
    public Optional<RepositoryHookType> getType() {
        return Optional.ofNullable(type);
    }

    public static class Builder {

        private Scope scope;
        private RepositoryHookType type;

        public Builder(@Nonnull Scope scope) {
            this.scope = requireNonNull(scope, "scope");
        }

        @Nonnull
        public RepositoryHookSearchRequest build() {
            return new RepositoryHookSearchRequest(this);
        }

        @Nonnull
        public Builder type(@Nonnull RepositoryHookType value) {
            type = requireNonNull(value, "type");
            return this;
        }
    }
}
