package com.atlassian.bitbucket.event.watch;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.watcher.Watcher;

import javax.annotation.Nonnull;

@TransactionAware
public abstract class WatcherEvent extends ApplicationEvent {

    private final Watcher watcher;

    protected WatcherEvent(@Nonnull Object source, @Nonnull Watcher watcher) {
        super(source);

        this.watcher = watcher;
    }

    @Nonnull
    public Watcher getWatcher() {
        return watcher;
    }
}
