package com.atlassian.bitbucket.event.user;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Raised when a user is deleted from all user directories visible to the server.
 * <p>
 * Clients that store data used to <em>authenticate</em> or <em>authorize</em> a user should subscribe to this event to
 * clean up data related to the deleted user. For example, if a plugin stores a secure key used to authenticate a user,
 * it should listen for this event and delete those keys. Note that content created by the user typically shouldn't be
 * deleted when the user is deleted, as it may still be of historical interest.
 * <p>
 * This event is raised for every deleted user.
 */
public class UserCleanupEvent extends ApplicationEvent {

    private final ApplicationUser deletedUser;

    public UserCleanupEvent(@Nonnull Object source, @Nonnull ApplicationUser deletedUser) {
        super(source);
        this.deletedUser = requireNonNull(deletedUser, "deletedUser");
    }

    @Nonnull
    public ApplicationUser getDeletedUser() {
        return deletedUser;
    }

}
