package com.atlassian.bitbucket.event.user;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

public abstract class UserAttributeChangedEvent extends ApplicationEvent {

    private final ApplicationUser updatedUser;

    UserAttributeChangedEvent(@Nonnull Object source, @Nonnull ApplicationUser updatedUser) {
        super(source);
        this.updatedUser = requireNonNull(updatedUser, "updatedUser");
    }

    @Nonnull
    public ApplicationUser getUpdatedUser() {
        return updatedUser;
    }
}
