package com.atlassian.bitbucket.event.repository;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Raised when a user is blocked from deleting a repository due to the repository delete policy. This event is not
 * fired when the user has permissions lower than REPO_ADMIN.
 *
 * @since 7.4
 */
@AsynchronousPreferred
@EventName("stash.repository.delete.blocked")
public class RepositoryDeleteBlockedEvent extends RepositoryEvent {

    private final boolean isPersonalRepo;
    private final boolean isPublicRepo;
    private final Permission userRole;

    public RepositoryDeleteBlockedEvent(@Nonnull Object source, @Nonnull Repository repository,
                                        @Nonnull Permission userRole, boolean isPersonalRepo, boolean isPublicRepo) {
        super(source, repository);

        this.isPersonalRepo = isPersonalRepo;
        this.isPublicRepo = isPublicRepo;
        this.userRole = requireNonNull(userRole, "userRole");
    }

    public boolean getIsPersonalRepo() {
        return isPersonalRepo;
    }

    public boolean getIsPublicRepo() {
        return isPublicRepo;
    }

    @Nonnull
    public Permission getUserRole() {
        return userRole;
    }
}
