package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.pull.PullRequestReviewersUpdatedActivity;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a reviewers updated activity is created for a pull request.
 * 
 * @since 4.4
 */
@AsynchronousPreferred
public class PullRequestReviewersUpdatedActivityEvent extends PullRequestActivityEvent {

    public PullRequestReviewersUpdatedActivityEvent(@Nonnull Object source, @Nonnull PullRequestReviewersUpdatedActivity activity) {
        super(source, activity);
    }

    @Nonnull
    @Override
    public PullRequestReviewersUpdatedActivity getActivity() {
        return (PullRequestReviewersUpdatedActivity) super.getActivity();
    }
}
