package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;

import javax.annotation.Nonnull;

/**
 * Base class for all the pull request review related events.
 *
 * @since 7.7
 */
public abstract class PullRequestReviewEvent extends PullRequestEvent {

    /**
     * @param source      the component raising the event
     * @param pullRequest the affected pull request
     * @param action      the action performed on the pull request
     */
    protected PullRequestReviewEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                  @Nonnull PullRequestAction action) {
        super(source, pullRequest, action);
    }
}
