package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a pending comment is added on a pull request.
 *
 * @since 7.7
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.review.comment.added")
public class PullRequestReviewCommentAddedEvent extends PullRequestReviewCommentEvent {

    /**
     * @param source        the component raising the event
     * @param pullRequest   the affected pull request
     * @param comment       the comment
     */
    public PullRequestReviewCommentAddedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                              @Nonnull Comment comment) {
        super(source, pullRequest, comment, null, CommentAction.ADDED);
    }
}
