package com.atlassian.bitbucket.event.pull;

import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * Base type for all pull request related events.
 * <p>
 * This event is internally audited with {@link CoverageLevel#BASE} level.
 */
@TransactionAware
public class PullRequestEvent extends ApplicationEvent {

    private final PullRequestAction action;
    private final PullRequest pullRequest;

    /**
     * Constructs a new {@code PullRequestEvent}. <i>All parameters are required.</i>
     *
     * @param source      the component raising the event
     * @param pullRequest the affected pull request
     * @param action      the action performed on the pull request
     */
    protected PullRequestEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                               @Nonnull PullRequestAction action) {
        super(source);

        this.pullRequest = requireNonNull(pullRequest, "pullRequest");
        this.action = requireNonNull(action, "action");
    }

    @Nonnull
    public PullRequestAction getAction() {
        return action;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return pullRequest;
    }
}
