package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;

/**
 * This event is raised before a user or group are granted a permission. This event is synchronous,
 * allowing listeners to perform operations in the same database transaction where the permission is granted.
 * <p>
 * This event is {@link CancelableEvent cancelable}. A listener may prevent the permission
 * from being granted by {@link #cancel(KeyedMessage) canceling} this event.
 * Throwing an exception <i>will not</i> prevent the permission from being granted;
 * the exception will be logged and ignored.
 */
public interface PermissionGrantRequestedEvent extends CancelableEvent {
}
