package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static com.google.common.base.Preconditions.checkArgument;
import static java.util.Objects.requireNonNull;

/**
 * Base event signalling permission changes.
 */
@TransactionAware
public abstract class PermissionEvent extends ApplicationEvent {

    private final Permission permission;
    private final String affectedGroup;
    private final ApplicationUser affectedUser;

    protected PermissionEvent(Object source, Permission permission,
                              String affectedGroup, ApplicationUser affectedUser) {
        super(source);
        checkArgument(requireNonNull(permission, "permission").isGrantable(), "Permission must be grantable");
        this.permission = permission;
        this.affectedGroup = affectedGroup;
        this.affectedUser = affectedUser;
    }

    @Nonnull
    public Permission getPermission() {
        return permission;
    }

    @Nullable
    public String getAffectedGroup() {
        return affectedGroup;
    }

    @Nullable
    public ApplicationUser getAffectedUser() {
        return affectedUser;
    }
}
